package com.hero.ui.dialog;

import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

import com.hero.objects.GenericObject;
import com.hero.objects.powers.Entangle;
import com.hero.objects.powers.SenseAdder;
import com.hero.ui.widgets.LevelTF;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class ElementalControlDialog extends GenericDialog {

	private static final long serialVersionUID = 4057421152827762624L;

	protected JLabel quantityLbl;

	protected LevelTF quantityTF;

	public ElementalControlDialog(com.hero.objects.ElementalControl list,
			boolean isNew) {
		super(list, isNew, true);
		if (isNew) {
			setTitle("New Elemental Control");
		} else {
			setTitle(list.getAlias());
		}
		init();
		displayLbl.setText("EC Name:");
		pointsLbl.setText("Base Points:");
	}

	@Override
	protected JPanel getTopPanel() {
		JPanel panel = super.getTopPanel();
		GridBagConstraints gbc = new GridBagConstraints();
		gbc.gridheight = 1;
		gbc.insets = new Insets(2, 5, 5, 2);
		gbc.fill = GridBagConstraints.HORIZONTAL;
		gbc.gridwidth = 1;
		gbc.gridx = 0;
		gbc.gridy = 84;
		gbc.weightx = 0;
		gbc.weighty = 0;
		gbc.anchor = GridBagConstraints.EAST;
		panel.add(quantityLbl, gbc);
		gbc.gridx = 1;
		gbc.gridwidth = 2;
		gbc.gridheight = 1;
		gbc.fill = GridBagConstraints.NONE;
		gbc.anchor = GridBagConstraints.WEST;
		panel.add(quantityTF, gbc);

		return panel;
	}

	@Override
	protected void initListeners() {
		super.initListeners();
		quantityTF.addPropertyChangeListener("Level",
				new PropertyChangeListener() {
					public void propertyChange(PropertyChangeEvent e) {
						if (object.getQuantity() == quantityTF.getCurrent()) {
							return;
						}
						object.setQuantity(quantityTF.getCurrent());
						GenericObject.lastEdit = System.currentTimeMillis();
						updateValues();
						if ((object instanceof SenseAdder)
								|| (object instanceof Entangle)) {
							layoutExtrasPanel();
						}
					}
				});

		displayTF.getDocument().addDocumentListener(new DocumentListener() {
			public void changedUpdate(DocumentEvent e) {
				okBtn.setEnabled(displayTF.getText().trim().length() > 0);
			}

			public void insertUpdate(DocumentEvent e) {
				okBtn.setEnabled(displayTF.getText().trim().length() > 0);
			}

			public void removeUpdate(DocumentEvent e) {
				okBtn.setEnabled(displayTF.getText().trim().length() > 0);
			}
		});
	}

	@Override
	protected void initWidgets() {
		super.initWidgets();
		quantityLbl = new JLabel("Quantity:");
		quantityTF = new LevelTF(object.getQuantity(), 9999, 1);
		addModifierBtn.setText("Add Common Modifier...");
	}

	@Override
	protected void layoutComponent() {
		layoutExtrasPanel();
		GridBagConstraints gbc = new GridBagConstraints();
		gbc.gridx = 0;
		gbc.gridy = 0;
		gbc.weightx = 1;
		gbc.weighty = 0;
		gbc.gridwidth = GridBagConstraints.REMAINDER;
		gbc.gridheight = 1;
		gbc.fill = GridBagConstraints.BOTH;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.insets = new Insets(0, 0, 0, 0);
		extrasPanel.add(adderPanel, gbc);
		gbc.gridy++;
		extrasPanel.add(privateAdderPanel, gbc);
		gbc.gridy++;
		extrasPanel.add(customAdderPanel, gbc);
		gbc.gridy++;
		gbc.weighty = 1;
		gbc.fill = GridBagConstraints.HORIZONTAL;
		extrasPanel.add(modifierPanel, gbc);
		gbc.gridy = 0;
		gbc.weighty = 0;
		gbc.fill = GridBagConstraints.BOTH;
		gbc.insets = new Insets(5, 5, 5, 5);
		JPanel panel = new JPanel(new GridBagLayout());
		panel.add(getTopPanel(), gbc);
		gbc.anchor = GridBagConstraints.WEST;
		gbc.fill = GridBagConstraints.NONE;
		gbc.gridwidth = 2;
		gbc.gridy++;
		panel.add(activePointsLbl, gbc);
		gbc.gridx = 1;
		gbc.anchor = GridBagConstraints.CENTER;
		panel.add(displayActivePointsCB, gbc);
		gbc.gridx = 2;
		gbc.anchor = GridBagConstraints.EAST;
		panel.add(realCostLbl, gbc);
		gbc.gridwidth = GridBagConstraints.REMAINDER;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.gridy++;
		gbc.gridx = 0;
		gbc.weighty = 1;
		gbc.weightx = 1;
		gbc.fill = GridBagConstraints.BOTH;
		panel.add(extrasScroll, gbc);
		gbc.gridy++;
		gbc.weighty = 0;
		gbc.weightx = 0;
		gbc.fill = GridBagConstraints.NONE;
		gbc.anchor = GridBagConstraints.NORTH;
		JPanel mods = new JPanel(new FlowLayout(FlowLayout.CENTER));
		mods.add(customAdderBtn);
		mods.add(privateAdderBtn);
		mods.add(addModifierBtn);
		panel.add(mods, gbc);
		gbc.gridy++;
		gbc.anchor = GridBagConstraints.SOUTH;
		gbc.gridy++;
		JPanel buttons = new JPanel(new FlowLayout(FlowLayout.CENTER));
		buttons.add(notesBtn);
		buttons.add(multiplierBtn);
		buttons.add(okBtn);
		buttons.add(deleteBtn);
		buttons.add(cancelBtn);
		buttons.add(defineBtn);
		panel.add(buttons, gbc);

		setContentPane(panel);
	}
}